#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include scripts\utility;
#include user_scripts\mp_patches\gunfight_sd\hud;
#include user_scripts\mp_patches\gunfight_sd\edits;
#include user_scripts\mp_patches\gunfight_sd\spawns;
#include user_scripts\mp_patches\gunfight_sd\setup;

testClone(){
    clone = self ClonePlayer( 2 );
    clone.origin = (level.flagSpawnPos+(0,0,500));
    clone startragdoll( 1 );
}

spawnFlag(baseOrigin)
{
    offsetRangeX = level.randomFlagRadiusX; // Larger range for X-axis
    offsetRangeY = level.randomFlagRadiusY;  // Small range for Y-axis
    offsetRangeZ = 10;  // Minimal vertical randomization

    attempts = 100; // Maximum attempts to find a valid position

    for (i = 0; i < attempts; i++)
    {
        // Generate random offsets within the defined range
        offsetX = randomInt(offsetRangeX * 2) - offsetRangeX; // e.g., -150 to 150
        offsetY = randomInt(offsetRangeY * 2) - offsetRangeY; // e.g., -20 to 20
        offsetZ = randomInt(offsetRangeZ * 2) - offsetRangeZ; // e.g., -10 to 10

        // Calculate the new origin by adding the offsets to the base origin
        newOrigin = (baseOrigin[0] + offsetX, baseOrigin[1] + offsetY, baseOrigin[2] + offsetZ);

        // Perform a downward trace to find the ground
        traceStart = newOrigin + (0, 0, 100); // Start trace slightly above
        traceEnd = newOrigin - (0, 0, 500);   // Extend trace far below to detect valid ground
        traceResult = PhysicsTrace(traceStart, traceEnd);

        // Debugging: Log trace results
        //iprintln("Attempt " + (i + 1) + ": Trace Start: " + traceStart + ", Trace End: " + traceEnd + ", Trace Result: " + traceResult);

        // Validate trace result
        if (
            isDefined(traceResult) &&
            traceResult[2] >= (baseOrigin[2] - 40) && // Z-axis check (must be near the original Z)
            traceResult[2] <= (baseOrigin[2] + 40)    // Z-axis check (must not be too high)
        )
        {
            // Spawn the flag at the validated location
            if(level.devMode){
                flag = spawn("script_model", traceResult);
                flag setModel("h1_flag_mp_domination_default");
            }

            // Print success message
            //iprintlnBold("Flag successfully spawned at: " + traceResult);
            return traceResult;
        }
    }

    // If no valid position was found, print an error
    iprintlnBold("Failed to spawn flag after " + attempts + " attempts. Please report to Bobby");
}

playDropEffects(pos){
    playFX(level._effect[ "fire_smoke_trail_l" ], pos);
    playFX(level._effect[ "fire_smoke_trail_m" ], pos);
    playFX(level._effect[ "fire_spawner_small_1_cgoshp" ], pos);
}

createFlag(pos){
	level.CaptureStatus["allies"] = 0;
	level.CaptureStatus["axis"] = 0;
	level.TeamOnFlag["allies"] = 0;
	level.TeamOnFlag["axis"] = 0;
    level.inOvertime = false;
    //while(!level.startRoundTimer)
    //    wait 2;
    level.flagTestSpawnPos = pos;
    level.flagSpawnPos = spawnFlag(pos);
	/*
	if(!isDefined(level.overtimeZone))
		level.overtimeZone = pos;
	pos = level.overtimeZone-(0,0,30);
    */
	//level waittill("begin_overtime");
    while(!level.overtime)
        wait 0.1;
    playFX(level._effect[ "flare_ambient" ], level.flagSpawnPos);
    playDropEffects(level.flagSpawnPos);
    flagPreSpawn = spawn( "script_model", level.flagSpawnPos );
	flagPreSpawn showInMap();
	level thread setBotsFlagGoal(level.flagSpawnPos);
	foreach(player in level.players)
		player createPlayerFlagHud();
	level thread warningLosing();
	level.flag = spawn( "script_model", level.flagSpawnPos-(0,0,5) );
	level.flag setModel( "h1_flag_mp_domination_default" );
	level thread monitorCapture(level.flagSpawnPos);
	level thread monitorFlagPlayers(level.flagSpawnPos);
	level.flag.headIcon = newHudElem();
	level.flag.headIcon.HideWhenInMenu = true;
	level.flag.headIcon.x = level.flag.origin[0];
	level.flag.headIcon.y = level.flag.origin[1];
	level.flag.headIcon.z = level.flag.origin[2]+140;
	level.flag.headIcon.alpha = 0.85;
	level.flag.headIcon setShader( level.flagIcon, 10,10 );
	level.flag.headIcon setWaypoint( true, true, false );
	level.flag.headIcon thread destroyOnEndGame();
	level.OvertimeCount = createserverfontstring("default", 1.7);
	level.OvertimeCount setPoint( "TOP CENTER", "TOP CENTER", 0, 55);
	level.OvertimeCount.color = ((255/255),(255/255),(0/255));
	level.OvertimeCount.alpha = 1;
	level.OvertimeCount.glowColor = ((0/255),(0/255),(0/255));
	level.OvertimeCount.glowAlpha = 0.3;
	level.OvertimeCount thread destroyOnEndGame();
	level.notified 	= [];
	level.notified["allies"] = false;
	level.notified["axis"] = false;
	level.notified_secure = [];
	level.notified_secure["allies"]	= false;
	level.notified_secure["axis"] = false;
    level.inOvertime = true;
	level.OverTimeCounter = getDvarInt("gf_overTime");
	while(game["state"] != "postgame" && level.inOvertime){
		if((level.PlayersOnFlag<=0 || level.FlagContested) && level.OverTimeCounter > 0){
			level decreaseOverTimeCount();
			wait 1;
		}
        else if((level.OverTimeCounter <= 0 && level.PlayersOnFlag<=0) || level.FlagContested){
			level decreaseOverTimeCount();
			break;
		}
		wait 0.025;
	}
    //iPrintLn(level.PlayersOnFlag);
	level notify("overtime_over");
	if(isDefined(level.OvertimeCount))
		level.OvertimeCount destroy();
	if(isDefined(level.flag.headIcon))
		level.flag.headIcon destroy();
}

decreaseOverTimeCount(text){
	self.OvertimeCount setSafeText(level.OverTimeCounter);
	self.OvertimeCount ChangeFontScaleOverTime( 0.1 );
	self.OvertimeCount.fontScale = 1.8;
	wait 0.1;
	level.OverTimeCounter--;
	self.OvertimeCount ChangeFontScaleOverTime( 0.1 );
	self.OvertimeCount.fontScale = 1.6;
}

warningLosing(){
	foreach(player in level.players){
		player playLocalSound( "mp_enemy_obj_returned" );
		if(!player.isWinning)
			player playlocalsound( level.warn_captureOrKill );
		else{
			player playLocalSound( level.warn_flagup );
		}
			
	}
}

monitorFlagPlayers(pos){
	self endon("disconnect");
	level.PlayersOnFlag = 0;
	level.TeamOnFlag["allies"] = 0;
	level.TeamOnFlag["axis"] = 0;
	while(game["state"] != "postgame"){
		tempPlayersOnFlag = 0;
		tempTeamOnFlagAllies = 0;
		tempTeamOnFlagAxis = 0;
		foreach(player in level.players){
			if(Distance(pos, player.origin) < 100 && isAlive(player)){
				if(player.team == "allies")
					tempTeamOnFlagAllies++;
				if(player.team == "axis")
					tempTeamOnFlagAxis++;
				tempPlayersOnFlag++;
			}
		}
		level.PlayersOnFlag = tempPlayersOnFlag;
		level.TeamOnFlag["allies"] = tempTeamOnFlagAllies;
		level.TeamOnFlag["axis"] = tempTeamOnFlagAxis;
		if(level.TeamOnFlag["allies"] >= 1 && level.TeamOnFlag["axis"] >= 1){
			level.FlagContested = true;
			setOverTimeText("Contested", ((255/255),(20/255),(0/255)));
			level.flag.headIcon.color = (1,0,0);
		}
		else if(level.TeamOnFlag["allies"] <= 0 && level.TeamOnFlag["axis"] <= 0){
			setOverTimeText("Overtime", ((255/255),(255/255),(0/255)));
			if(!level.FlagContested)
				level.flag.headIcon.color = (1,1,1);
			level.notified["allies"] = false;
			level.notified["axis"] = false;
			level.notified_secure["allies"]	= false;
			level.notified_secure["axis"] = false;
		}
		else if(level.TeamOnFlag["allies"] >= 1 && level.TeamOnFlag["axis"] <= 0){
			setOverTimeText("Capturing", undefined);
		}
		else if(level.TeamOnFlag["axis"] >= 1 && level.TeamOnFlag["allies"] <= 0){
			setOverTimeText("Capturing", undefined);
		}
		else
			setOverTimeText("Overtime", ((255/255),(255/255),(0/255)));
		//level notify("check_flag");
		wait 0.015;
	}
}

monitorCapture(pos){
	self endon("disconnect");
	level endon("overtime_over");
	foreach(player in level.players)
		player thread doFlagCapture(pos);
	while(game["state"] != "postgame")
		wait 0.025;
	foreach(player in level.players){
		player freezeControls(true);
		player notify("overtime_over");
	}
}

doFlagCapture(pos){
	self endon("dealth");
	self endon("disconnect");
	level endon("overtime_over");
	while(game["state"] != "postgame"){
		if(Distance(pos, self.origin) <= 100 && isAlive(self)){
			if(self.team == "allies" && level.TeamOnFlag["axis"] == 0){
				level.FlagContested = false;
				self thread notifyEnemy("axis");
				self thread notifyAllies("allies");
				//self thread showFlagStatus(pos);
				level.CaptureStatus[self.team]+=1.75;
				if(level.CaptureStatus[self.team] > 100)
					level.CaptureStatus[self.team] = 100;
				self.CaptureBar updateBar(level.CaptureStatus[self.team]/100);
				if(!level.FlagContested)
					level.flag.headIcon.color = (1,1,0);
				if(level.CaptureStatus[self.team] >= 100){
					level.CaptureStatus[self.team] = 100;
					level.FlagOverride = true;
					level.OverrideWinners = self.team;
					foreach(player in level.players){
						player freezeControls(true);
						player notify("overtime_over");
						if(player.team == "allies")
							player playLocalSound(level.warn_alliecaptured);
						else if(player.team == "axis")
							player playLocalSound(level.warn_enemycaptured);
					}
					level notify("overtime_over");
				}
			}
			else if(self.team == "axis" && level.TeamOnFlag["allies"] == 0){
				level.FlagContested = false;
				self thread notifyEnemy("allies");
				self thread notifyAllies("axis");
				//self thread showFlagStatus(pos);
				level.CaptureStatus[self.team]+=1.75;
				if(level.CaptureStatus[self.team] > 100)
					level.CaptureStatus[self.team] = 100;
				self.CaptureBar updateBar(level.CaptureStatus[self.team]/100);
				if(!level.FlagContested)
					level.flag.headIcon.color = (1,1,0);
				if(level.CaptureStatus[self.team] >= 100){
					level.CaptureStatus[self.team] = 100;
					level.FlagOverride = true;
					level.OverrideWinners = self.team;
					foreach(player in level.players){
						player freezeControls(true);
						player notify("overtime_over");
						if(player.team == "axis")
							player playLocalSound(level.warn_alliecaptured);
						else if(player.team == "allies")
							player playLocalSound(level.warn_enemycaptured);
					}
					level notify("overtime_over");
				}
			}
		}
		wait 0.025;//capture time
	}
}

setOverTimeText(text, color){
	if(text == "Capturing"){
		level.OvertimeCount.alpha = 0;
		foreach(player in level.players){
			if(player.team == "axis" && level.TeamOnFlag["allies"] >= 1){
				player.OvertimeText.color = level.teamColor["enemy"];
				player.OvertimeText setSafeText("Enemy Is Capturing!");
			}
			else if(player.team == "allies" && level.TeamOnFlag["axis"] >= 1){
				player.OvertimeText.color = level.teamColor["enemy"];
				player.OvertimeText setSafeText("Enemy Is Capturing!");
			}
			else if(player.team == "axis" && level.TeamOnFlag["axis"] >= 1){
				player.OvertimeText.color =level.teamColor["friendly"];
				player.OvertimeText setSafeText("Capturing!");
			}
			else if(player.team == "allies" && level.TeamOnFlag["allies"] >= 1){
				player.OvertimeText.color =level.teamColor["friendly"];
				player.OvertimeText setSafeText("Capturing!");
			}
		}
	}
	else{
		level.OvertimeCount.alpha = 1;
		foreach(player in level.players){
			player.OvertimeText.color = color;
			player.OvertimeText setSafeText(text);
		}
	}
	level.OvertimeCount.color = color;
}

setWarnings(){
	//level.warn_securing = "PG_1mc_freeforall_pro";//We are securing the flag!
	switch(randomint(4)){
		case 0:
			level.warn_captureOrKill = "AB_1mc_getflag_takedown";
			level.warn_capturing = "AB_1mc_flag_captured";
			level.warn_securing = "AB_1mc_capturing_a";
			level.warn_flagup = "AB_1mc_flag_up";
			level.warn_overtime = "AB_1mc_overtime";
			level.warn_enemycaptured = "AB_1mc_ourflag_capt";
			level.warn_alliecaptured = "AB_1mc_enemyflag_capt";
			level.warn_losingFight = "AB_1mc_losing_fight";
			level.warn_winningFight = "AB_1mc_winning_fight";
			level.warn_draw = "AB_1mc_draw";
		break;
		case 1:
			level.warn_captureOrKill = "PG_1mc_getflag_takedown";
			level.warn_capturing = "PG_1mc_flag_captured";
			level.warn_securing = "PG_1mc_capturing_a";
			level.warn_flagup = "PG_1mc_flag_up";
			level.warn_overtime = "PG_1mc_overtime";
			level.warn_enemycaptured = "PG_1mc_ourflag_capt";
			level.warn_alliecaptured = "PG_1mc_enemyflag_capt";
			level.warn_losingFight = "PG_1mc_losing_fight";
			level.warn_winningFight = "PG_1mc_winning_fight";
			level.warn_draw = "PG_1mc_draw";
		break;
		case 2:
			level.warn_captureOrKill = "RU_1mc_getflag_takedown";
			level.warn_capturing = "RU_1mc_flag_captured";
			level.warn_securing = "RU_1mc_capturing_a";
			level.warn_flagup = "RU_1mc_flag_up";
			level.warn_overtime = "RU_1mc_overtime";
			level.warn_enemycaptured = "RU_1mc_ourflag_capt";
			level.warn_alliecaptured = "RU_1mc_enemyflag_capt";
			level.warn_losingFight = "RU_1mc_losing_fight";
			level.warn_winningFight = "RU_1mc_winning_fight";
			level.warn_draw = "RU_1mc_draw";
		break;
		case 3:
			level.warn_captureOrKill = "NS_1mc_getflag_takedown";
			level.warn_capturing = "NS_1mc_flag_captured";
			level.warn_securing = "NS_1mc_capturing_a";
			level.warn_flagup = "NS_1mc_flag_up";
			level.warn_overtime = "NS_1mc_overtime";
			level.warn_enemycaptured = "NS_1mc_ourflag_capt";
			level.warn_alliecaptured = "NS_1mc_enemyflag_capt";
			level.warn_losingFight = "NS_1mc_losing_fight";
			level.warn_winningFight = "NS_1mc_winning_fight";
			level.warn_draw = "NS_1mc_draw";
		break;
		default:
			level.warn_captureOrKill = "PG_1mc_getflag_takedown";
			level.warn_capturing = "PG_1mc_flag_captured";
			level.warn_securing = "PG_1mc_capturing_a";
			level.warn_flagup = "PG_1mc_flag_up";
			level.warn_overtime = "PG_1mc_overtime";
			level.warn_enemycaptured = "PG_1mc_ourflag_capt";
			level.warn_alliecaptured = "PG_1mc_enemyflag_capt";
			level.warn_losingFight = "PG_1mc_losing_fight";
			level.warn_winningFight = "PG_1mc_winning_fight";
			level.warn_draw = "PG_1mc_draw";
		break;
	}
}

notifyEnemy(enemyteam){
	if(level.notified[enemyteam] == false){
		level.notified[enemyteam] = true;
		foreach(player in level.players){
			if(player.team == enemyteam)
				player playlocalsound( level.warn_capturing );
		}
	}
}

notifyAllies(myteam){
	if(level.notified_secure[myteam] == false){
		level.notified_secure[myteam] = true;
		foreach(player in level.players){
			if(player.team == myteam)
				player playlocalsound( level.warn_securing );
		}
	}
}

showInMap()
{
	curObjID = maps\mp\gametypes\_gameobjects::getNextObjID();	
	name = precacheShader( "compass_waypoint_panic" );	
	objective_add( curObjID, "invisible", (0,0,0) );
	objective_position( curObjID, self.origin );
	objective_state( curObjID, "active" );
	objective_team( curObjID, self.team );
	objective_icon( curObjID, name );
	self.objIdFriendly = curObjID;
}

checkGamemode(){
	if(!level.checkedGamemode){
		level.checkGamemode = true;
		if( getDvar( "g_gametype" ) != "sd"){
			self iPrintlnBold( "Incorrect Gamemode!" );
			setDvar("g_gametype","sd");
			wait 5;
			self iPrintlnBold( "^2Restarting..." );
			wait 5;
			map_restart(false);
		}
	}
}


destroyForDeath(chopper){
	self waittill("death");
	chopper delete();
}

setSafeText(text)
{
	if(self.oldText != text)
	{
		self.oldText = text;
		self setText(text);
	}
}

startExfilHeli(){
    dropSite = level.flagTestSpawnPos;
	dropYaw = randomFloat( 360 );
	heightAdjustment = 0;
    dropType = "airdrop_marker_mp";

	flyHeight = self maps\mp\h2_killstreaks\_airdrop::getFlyHeightOffset( dropSite );

	if ( !isDefined(heightAdjustment) )
		heightAdjustment = 0;

	flyHeight += heightAdjustment;

	pathGoal = dropSite * (1,1,0) +  (0,0,flyHeight);	
	pathStart = maps\mp\h2_killstreaks\_airdrop::getPathStart( pathGoal, dropYaw );
	pathEnd = maps\mp\h2_killstreaks\_airdrop::getPathEnd( pathGoal, dropYaw );		

	pathGoal = pathGoal + vector_multiply( anglestoforward( (0,dropYaw,0) ), -50 );

	chopper = maps\mp\h2_killstreaks\_airdrop::heliSetup( self, pathStart, pathGoal );

	chopper endon( "death" );

	chopper.dropType = dropType;
	assert ( isDefined( chopper ) );

	chopper setVehGoalPos( pathGoal, 1 );

	//chopper thread dropTheCrate( dropSite, dropType, flyHeight, false, undefined , pathStart );

	wait ( 2 );

	chopper Vehicle_SetSpeed( 300, 75 );
	chopper SetYawSpeed( 180, 180, 180, .3 );

	chopper waittill ( "goal" );
    wait 0.5;
    chopper notify( "drop_crate" );
    wait 3;
	chopper setvehgoalpos( pathEnd, 1 );
	chopper Vehicle_SetSpeed( 300, 75 );
    //wait randomFloatRange(0.2,0.5);
    
	chopper.leaving = true;
	chopper waittill ( "goal" );
	chopper notify( "leaving" );
	chopper maps\mp\h2_killstreaks\_airdrop::trimActiveBirdList();
	maps\mp\h2_killstreaks\_airdrop::decrementLittleBirdCount();
	chopper notify( "delete" );
	chopper delete();
}

dropTheCrate( dropPoint, dropType, lbHeight, dropImmediately, crateOverride, startPos )
{
	dropCrate = [];
	self.owner endon ( "disconnect" );

	if ( !isDefined( crateOverride ) )
		crateType = maps\mp\h2_killstreaks\_airdrop::getCrateTypeForDropType( dropType );		
	else
		crateType = crateOverride;

	dropCrate = createAirDropCrate( self.owner, dropType, crateType, startPos );

    //tempflag = spawn( "script_model", startPos );
	//tempflag setModel( "h1_flag_mp_domination_default" );
    //tempflag linkto(dropCrate);

	dropCrate LinkTo( self, "tag_ground" , (32,0,5) , (0,0,0) );

	dropCrate.angles = (0,0,0);
	dropCrate show();
	dropSpeed = self.veh_speed;

	self waittill ( "drop_crate" );

	dropCrate Unlink();
	dropCrate PhysicsLaunchServer( (0,0,0), (0,0,0), 1200 );
	//dropCrate thread maps\mp\h2_killstreaks\_airdrop::physicsWaiter( dropType, crateType );

    //dropCrate waittill( "physics_finished" );
    //wait 2.2;
    oldZ = dropCrate.origin[2];
    while(dropCrate.origin[2] <= oldZ){
        oldZ = dropCrate.origin[2];
        wait 0.025;
    }
    playDropEffects(dropCrate.origin);
    dropCrate delete();
}

createAirDropCrate( owner, dropType, crateType, startPos )
{
	dropCrate = spawn( "script_model", startPos );
	dropCrate.owner = undefined;
	dropCrate.dropType = dropType;
	//dropCrate setModel( maps\mp\h2_killstreaks\_airdrop::h2_getTeamCrateModel( dropCrate.team ) );
	dropCrate = spawn( "script_model", startPos );
	dropCrate setModel( "com_plasticcase_friendly" );

	if( isDefined( level.airDropCrateCollision ) )
		dropCrate CloneBrushmodelToScriptmodel( level.airDropCrateCollision );

	return dropCrate;
}